 	real*8 function gasfun(xi,nterms)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasfun.f,v 3.15 2005/01/29 17:06:56 friedrich Exp friedrich $
c
c  this function calculates the fit function and the derivatives
c  to the parameters but the latter only if fixed(i)=.false.
c  the background polynomial is calculated only if nterms le.0
c  the fit function is assumed to be a gaussian with fast decaying
c  peak tails on each side, a long decaying leftside background
c  tail and a polynomial to fit the background with maximum
c  degree of 4:
c
c  gasfun=sum { ag*[exp(-es**2)+al*exp(+el)*erfc(es+sl))
c              +ab*exp(xt)*erfc(es+sb) + ar*(exp(-er)*erfc(-es+sr)]}
c              +c0 + c1*xi + c2*xi^2 + c3*xi^3 + c4*xi^4
c  the sum runs over kpeaks peaks
c  with the parameters in the common array /par/:
c      ampg2  = par(kj)^2
c      gamma = parc(kj)*{1.+parc(2*kpeaks+1)*psin[par(2*kpeaks+1)]}
c      x(j)  = parc(j)+parc(2*kpeaks+2)*psin[par(j)]
c      xg    = (xi-x(j))/gamma
c tail left
c      amp  = par(2*kpeaks+7)*poly(parc(j), nampleft, ampleft)
c      ftaul ={1.0+parc(2*keaks+8)*psin[par(2*kpeaks+8)]}
c      tau   = ftaul*poly(parc(j), ntauleft, tauleft)
c      al    = amp*amp
c      xt    = (xi-x(j))/tau
c      g2t    = 0.5*gamma/tau
c tail background
c      amp  = par(2*kpeaks+9)*poly(parc(j), nampback, ampback)
c      ftaub ={1.0+parc(2*keaks+10)*psin[par(2*kpeaks+10)]}
c      tau   = ftaub*poly(parc(j), ntauback, tauback)    
c      ab    = amp*amp
c      xt    = (xi-x(j))/tau
c      sb    = 0.5*gamma/tau
c tail right
c      amp  = par(2*kpeaks+11)*poly(parc(j), nampright, ampright)
c      ftaur ={1.0+parc(2*keaks+12)*psin[par(2*kpeaks+12)]}
c      tau   = ftaur*poly(parc(j), ntauright, tauright)   
c      ar    = amp*amp
c      er    = (xi-x(j))/tau
c      sr    = 0.5*gamma/tau
c step
c      amp  = par(2*kpeaks+13)*poly(parc(j), nampstep, ampstep)
c      ar    = amp*amp
c      xt    = (xi-x(j))/tau
c background
c      c0   = par(2*kpeaks+2)
c      c1   = par(2*kpeaks+3)
c      c2   = par(2*kpeaks+4)
c      c3   = par(2*kpeaks+5)
c      c4   = par(2*kpeaks+6)
c  the tails and the step can be switched on or of via logical variables
c   see phillips et. al.  nim 137 (1976),525
c  10.09.86  vax version
c  13.06.79  f. riess
c------------------------------------------------------------------
	implicit none
	integer nterms
	real*8 xi

	include 'gasctr.icl'
	include 'gaspar.icl'
        include 'gaseic.icl'

	integer i, j, jc, jcall, ja, jw, jwc, jwall
	real*8 poly, erfc, erfcd, psin, pcos
	real*8 amp, tau, ampl2, ftaul, ampr2, ftaur, ampb2, ftaub, amps2, xt, g2t, x0
	real*8 gamma, gp, xij, xg, xg2, xr, z
        real*8 ampg, ampg2, f1, fg, ftv, ftp, result, dpos, dwid
	real*8 sumlamp, sumltau, sumramp, sumrtau, sumwidth, sumbamp, sumbtau, sumpos, sumsamp

c  background polynomial
	x0 = xi - parc(pospolm)
	deriv(pospol) = 1.
	f1 = x0
	result = par(pospole)
	do i = 1, 4
	  deriv(pospol + i) = f1
	  f1 = f1*x0
	  result = result*x0 + par(pospole - i)
	end do
	gasfun = result
	if(nterms.le.0) return
c  all widths together
	sumwidth = 0.d+00
        jwall = 0
c  all peaks position are commonly varied
	sumpos=0.d+00
        jcall = 0
c  left side peak tail
	if(taill) then
          ampl2 = par(postla)**2
	  ftaul = 1.d+00 + parc(postlw)*psin(par(postlw))
	  sumlamp = 0.d+00
          sumltau = 0.d+00
	end if
c  background tail
	if(tailb) then
          ampb2 = par(postba)**2
	  ftaub = 1.d+00 + parc(postbw)*psin(par(postbw))
 	  sumbamp = 0.d+00
	  sumbtau = 0.d+00
	end if
c  right side peak tail
	if(tailr) then
          ampr2 = par(postra)**2
	  ftaur = 1.d+00 + parc(postrw)*psin(par(postrw))
	  sumramp = 0.d+00
	  sumrtau = 0.d+00
	end if
c step
	if(lstep) then
          amps2 = par(possta)**2
	  sumsamp = 0.d+00
        endif
c  go through all peaks
        jc = poscen
        ja = posarea
        jw = poswidth
        jwc = poscwidth 
	do j = 1,kpeaks
	  ampg = par(ja)
	  ampg2 = ampg*ampg
	  gp = 1.d+00 + fwhmrange*psin(par(jw))
	  gamma = parc(jwc)*gp
          if(posall) then
            xr = cenrange
          else
            xr = parc(jwc) 
          endif
	  xij = xi - parc(jc) - xr*psin(par(jc))
	  xg = xij/gamma
	  xg2 = xg*xg
	  if(xg2.lt.20.d+00) then
	    fg = ampg2*exp(-xg2)
	  else
	    fg = 0.d+00
	  end if
          f1 = fg
	  if(.not.fixed(jc)) dpos = 2.d+00*xg*fg
	  if(.not.fixed(jw)) dwid = 2.d+00*xg2*fg
	  if(taill) then
            tau = poly(parc(jc), max(1, ntauleft), tauleft)
            tau = max(0.1, tau*ftaul)
	    xt = xij/tau
	    if(abs(xt).lt.20.d+00) then
	      amp = poly(parc(jc), max(1, nampleft), ampleft)
              ftp = amp*ampg2*exp(xt)
	      g2t = 0.5d+00*gamma/tau
	      z = xg + g2t
	      if(z.lt.8.d+00) then
		if(z.lt.(-3.6d+00)) then
                  ftv = 2.d+00*ftp
                  ftp = 0.d+00
		else
  	          ftv = ftp*erfc(z)
                  ftp = ampl2*ftp*erfcd(z)
		endif
	        if (.not.fixed(postla)) sumlamp = sumlamp + ftv
		ftv = ampl2*ftv
                f1 = f1 + ftv
	        if (.not.fixed(jc)) dpos = dpos - 2.d+00*g2t*ftv - ftp
	        if (.not.fixed(jw)) dwid = dwid + (-xg + g2t)*ftp
	        if (.not.fixed(postlw)) sumltau = sumltau + xt*ftv + g2t*ftp
	      endif
	    end if
	  end if
	  if(tailb) then
            tau = poly(parc(jc), max(1, ntauback), tauback)
            tau = max(0.1, tau*ftaub)
	    xt = xij/tau
	    if(abs(xt).lt.20.d+00) then
              amp = poly(parc(jc), max(1, nampback), ampback)
              ftp = amp*ampg2*exp(xt)
	      g2t = 0.5d+00*gamma/tau
	      z = xg + g2t
	      if(z.lt.8.d+00) then
		if(z.lt.(-3.6d+00)) then
		  ftv = 2.d+00*ftp
                  ftp = 0.d+00
		else
  	          ftv = ftp*erfc(z)
                  ftp = ampb2*ftp*erfcd(z)
		endif
	        if (.not.fixed(postba)) sumbamp = sumbamp + ftv
                ftv = ampb2*ftv
                f1 = f1 + ftv
	        if (.not.fixed(jc)) dpos = dpos - 2.d+00*g2t*ftv - ftp
	        if (.not.fixed(jw)) dwid = dwid + (-xg + g2t)*ftp
	        if (.not.fixed(postbw)) sumbtau = sumbtau + xt*ftv + g2t*ftp
	      end if
	    end if
	  end if
	  if(tailr) then
            tau = poly(parc(jc), max(1, ntauright), tauright)
            tau = max(0.1, tau*ftaur)
	    xt = xij/tau
	    if(abs(xt).lt.20.d+00) then
              amp = poly(parc(jc), max(1, nampright), ampright)
              ftp = amp*ampg2*exp(-xt)
	      g2t = 0.5d+00*gamma/tau
	      z = -xg + g2t
	      if(z.lt.8.d+00) then
		if(z.lt.(-3.6d+00)) then
		  ftv = 2.d+00*ftp
                  ftp = 0.d+00
		else
  	          ftv = ftp*erfc(z)
                  ftp = ampr2*ftp*erfcd(z)
		endif
	        if (.not.fixed(postra)) sumramp = sumramp + ftv
		ftv = ampr2*ftv
                f1 = f1 + ftv
	        if (.not.fixed(jc)) dpos = dpos + 2.d+00*g2t*ftv + ftp
	        if (.not.fixed(jw)) dwid = dwid + (xg + g2t)*ftp
	        if (.not.fixed(postrw)) sumrtau = sumrtau + xt*ftv - g2t*ftp
	      end if
	    end if
	  end if
	  if(lstep) then
            amp = poly(parc(jc), max(1, nampstep), ampstep)
            ftp = amp*ampg2
	    z = xg
	    if(z.lt.8.d+00) then
	      if(z.lt.(-3.6d+00)) then
		ftv = 2.d+00*ftp
                ftp = 0.d+00
	      else
  	        ftv = ftp*erfc(z)
                ftp = amps2*ftp*erfcd(z)
	      endif
	      if (.not.fixed(possta)) sumsamp = sumsamp + ftv
              ftv = amps2*ftv
              f1 = f1 + ftv
	      if (.not.fixed(jc)) dpos = dpos - ftp
	      if (.not.fixed(jw)) dwid = dwid - xg*ftp
	    end if
	  end if
	  if(.not.fixed(ja) .and. ampg.ne.0.) deriv(ja) = 2.d+00*f1/ampg
	  if(.not.fixed(jc)) then
	    deriv(jc) = dpos*xr*pcos(par(jc))/gamma
	    if(posall) then
              sumpos = sumpos + deriv(jc)
              deriv(jc) = 0.d+00
              if(jcall.le.0) jcall = jc
            endif
	  end if
	  if(.not.fixed(jw)) then
            deriv(jw) = dwid*fwhmrange*pcos(par(jw))/gp
            if(widthall) then
              sumwidth = sumwidth + deriv(jw)
              deriv(jw) = 0.d+00
              if(jwall.le.0) jwall = jw
            endif
          endif
	  result = result + f1
          jc = jc + 1
          ja = ja + 1
          jwc = jwc + 1
          if(ELEMENTS.gt.2) jw = jw + 1
	end do
	if(posall .and. jcall.gt.0) deriv(jcall) = sumpos
        if(widthall .and. jwall.gt.0) deriv(jwall) = sumwidth
        
	if(.not.fixed(postla))deriv(postla) = 2.d+00*par(postla)*sumlamp
	if(.not.fixed(postlw))deriv(postlw) = -sumltau*parc(postlw)*pcos(par(postlw))/ftaul
	if(.not.fixed(postba))deriv(postba) = 2.d+00*par(postba)*sumbamp
	if(.not.fixed(postbw))deriv(postbw) = -sumbtau*parc(postbw)*pcos(par(postbw))/ftaub
	if(.not.fixed(postra))deriv(postra) = 2.d+00*par(postra)*sumramp
	if(.not.fixed(postrw))deriv(postrw) = sumrtau*parc(postrw)*pcos(par(postrw))/ftaur
	if(.not.fixed(possta))deriv(possta) = 2.d+00*par(possta)*sumsamp
	gasfun=result
        return
	end
